<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Wyslij_email
{
    private $CI;

    function __construct()
	{
		$this->CI = & get_instance();
		$this->CI->config->load('global_settings');
    }

   function send_mail($title=null, $content_message=null, $email_do=null)
   {
        if(!empty($title) and !empty($content_message) and !empty($email_do))
        {
            require_once 'files/swift-4.0.5/lib/swift_required.php';

            $global_settings = $this->CI->config->item('global_settings');

            $transport = Swift_SmtpTransport::newInstance($global_settings['smtp']['smtp_serwer'],$global_settings['smtp']['smtp_port'])
            ->setUsername($global_settings['smtp']['smtp_user'])
            ->setPassword($global_settings['smtp']['smtp_password']);

            $mailer = Swift_Mailer::newInstance($transport);

            $body =  $content_message;

            $message = Swift_Message::newInstance($title)
              ->setFrom(array($global_settings['smtp']['smtp_user'] => 'Networds System [no reply]'))
              ->setTo($email_do)
              ->setBody($body, 'text/html', 'utf-8')
              //->setReadReceiptTo('robert@labmatic.com')
              ->setBcc(array('kuba@labmatic.com', 'kamila.gronner@networds.pl'));

            $headers = $message->getHeaders();
            $headers->addTextHeader('Reply-To',$global_settings['smtp']['smtp_user']);

            $result = $mailer->send($message);            
            return $result;
        }
        else
        {
            return false;
        }
    }

   function send_mail_with_attach($title=null, $content_message=null, $email_do=null, $url_atach_pdf=null)
   {
        if(!empty($title) and !empty($content_message) and !empty($email_do))
        {
            require_once 'files/swift-4.0.5/lib/swift_required.php';

            $global_settings = $this->CI->config->item('global_settings');

            $transport = Swift_SmtpTransport::newInstance($global_settings['smtp']['smtp_serwer'],$global_settings['smtp']['smtp_port'])
            ->setUsername($global_settings['smtp']['smtp_user'])
            ->setPassword($global_settings['smtp']['smtp_password']);

            $mailer = Swift_Mailer::newInstance($transport);

            $body =  $content_message;

            $message = Swift_Message::newInstance($title)
              ->setFrom(array($global_settings['smtp']['smtp_user'] => 'Networds System [no reply]'))
              ->setTo($email_do)
              ->setBody($body, 'text/html', 'utf-8');
              ;

            //Create your file contents in the normal way, but don't write them to disk
            $data = file_get_contents($url_atach_pdf);
            
            //Create the attachment with your data
            $attachment = Swift_Attachment::newInstance($data, 'faktura.pdf', 'application/pdf');

            //Attach it to the message
            $message->attach($attachment);


            //You can alternatively use method chaining to build the attachment
            $attachment = Swift_Attachment::newInstance()
              ->setFilename('faktura.pdf')
              ->setContentType('application/pdf')
              ->setBody($data)
              ;


            $headers = $message->getHeaders();
            $headers->addTextHeader('Reply-To',$global_settings['smtp']['smtp_user']);

            $result = $mailer->send($message);
            return $result;
        }
        else
        {
            return false;
        }
	}
}

?>