<?php
class Master extends Controller {
	private $user_data;
	private $login	= false;
	
	function Master()
	{
		parent::Controller();
		$this->load->library('session');	
		$this->load->helper(array('form', 'url','html'));
		$this->load->model('baza','',TRUE);
		
		$this->checkLogin();
	}
	//------------------------------------------------------------------------------------------------------------------
	/* sprawdza uzytkownika czy jest zalogowany */	
	function checkLogin()
	{
	
		if(isset($this->session->userdata['user_master_zalogowany']) and isset($this->session->userdata['master_id']))
		{
			$this->login 		= true;
			$this->user_data 	= $this->baza->master_get_user_login($this->session->userdata['user_master_zalogowany'], $this->session->userdata['master_id']);
			if(empty($this->user_data))
				$this->login 		= false;
		}
		
		if($this->uri->segment(2))
		{
				$metoda = $this->uri->segment(2);
				if($metoda != 'login' && !$this->login)
					redirect('/master/login', 'location');						
		}
	}
	//------------------------------------------------------------------------------------------------------------------
	function index()
	{
		redirect('/master/start/','location');
	}
	//------------------------------------------------------------------------------------------------------------------	
	function start()
	{
		$data['user']  			= $this->user_data[0]['name'];
		$data['mainContent']	= $this->load->view('master/start',$data,true);
		$this->load->view('/layout/master',$data);
	}
	//------------------------------------------------------------------------------------------------------------------
	function masters($info_id = null)
	{
		$data['user']  			= $this->user_data[0]['name'];
		$data['master_id']		= $this->session->userdata['master_id'];
		
		//wykluczenie zalogowanego uzytkownika
		$excluded_ids = array($data['master_id']);
		if(!empty($info_id))
		{
			if($info_id == 1)
				$data['message']	= 'Operacja została wykonana pomyślnie !';
			elseif($info_id == 0)
				$data['message']	= 'Wystapił błąd !';
		}
		
		$data['masters']		= $this->baza->get_all_masters($excluded_ids);
		$data['mainContent']	= $this->load->view('master/masters',$data,true);
		$this->load->view('/layout/master',$data);		
	}
	//------------------------------------------------------------------------------------------------------------------
	function employees($info_id = null)
	{
		$data['user']  			= $this->user_data[0]['name'];
		$data['master_id']		= $this->session->userdata['master_id'];
		
		//wykluczenie zalogowanego uzytkownika
		$excluded_ids = array($data['master_id']);
		if(!empty($info_id))
		{
			if($info_id == 1)
				$data['message']	= 'Operacja została wykonana pomyślnie !';
			elseif($info_id == 0)
				$data['message']	= 'Wystapił błąd !';
		}
		
		$data['employees']		= $this->baza->get_all_employees();
		$data['mainContent']	= $this->load->view('master/employees',$data,true);
		$this->load->view('/layout/master',$data);				
	}
	//------------------------------------------------------------------------------------------------------------------
	function add_master()
	{
		$data['user']  			= $this->user_data[0]['name'];
		$data['master_id']		= $this->session->userdata['master_id'];
		$form_data				= null;
		$errors					= null;
		
		if(!empty($_POST))
		{
			$form_data['imie']   = trim($_POST['imie']);
			$form_data['email']  = trim($_POST['email']);
			$form_data['haslo']  = trim($_POST['haslo']);
			$form_data['haslo2'] = trim($_POST['haslo2']);
			
			if(!$this->is_valid_email($form_data['email']))
				$errors['email'] = 'Niepoprawny adres email.';
						
			if(empty($form_data['imie']))
				$errors['imie'] = 'Wartośc pola nie może być pusta';

			if(empty($form_data['haslo']))
				$errors['haslo'] = 'Wartośc pola nie może być pusta';
				
			if(empty($form_data['email']))
				$errors['email'] = 'Wartośc pola nie może być pusta';				
								
			if(!$this->baza->is_unique_master_name($_POST['imie']))
				$errors['imie'] = 'Uzytkownik o podanym imieniu już istnieje w bazie.';
				
			if($form_data['haslo'] != $form_data['haslo2'])	
				$errors['haslo2'] = 'Nieprawidłowe potwierdzenie hasła';
				
				if($form_data != null && $errors != null)
				{
					$data['form_data']	    = $form_data;	
					$data['errors']	  		= $errors;
				}
				else
				{
					$this->baza->add_master($form_data['imie'],$form_data['haslo'],$form_data['email']);
					redirect('/master/masters/1','location');					
				}
				
		}
		//wykluczenie zalogowanego uzytkownika
		$excluded_ids = array($data['master_id']);
		
		$data['masters']		= $this->baza->get_all_masters($excluded_ids);
		$data['mainContent']	= $this->load->view('master/add_master_form',$data,true);
		$this->load->view('/layout/master',$data);		
		
	}
	//------------------------------------------------------------------------------------------------------------------
	function add_employee()
	{
		$data['user']  			= $this->user_data[0]['name'];
		$data['master_id']		= $this->session->userdata['master_id'];
		$form_data				= null;
		$errors					= null;
		
		if(!empty($_POST))
		{
			$form_data['imie']   = trim($_POST['imie']);
			$form_data['email']  = trim($_POST['email']);
			$form_data['haslo']  = trim($_POST['haslo']);
			$form_data['haslo2'] = trim($_POST['haslo2']);
			
			if(!$this->is_valid_email($form_data['email']))
				$errors['email'] = 'Niepoprawny adres email.';
						
			if(empty($form_data['imie']))
				$errors['imie'] = 'Wartośc pola nie może być pusta';

			if(empty($form_data['haslo']))
				$errors['haslo'] = 'Wartośc pola nie może być pusta';
				
			if(empty($form_data['email']))
				$errors['email'] = 'Wartośc pola nie może być pusta';				
								
			if(!$this->baza->is_unique_employee_name($_POST['imie']))
				$errors['imie'] = 'Uzytkownik o podanym imieniu już istnieje w bazie.';
				
			if($form_data['haslo'] != $form_data['haslo2'])	
				$errors['haslo2'] = 'Nieprawidłowe potwierdzenie hasła';
				
				if($form_data != null && $errors != null)
				{
					$data['form_data']	    = $form_data;	
					$data['errors']	  		= $errors;
				}
				else
				{
					$this->baza->add_employee($form_data['imie'],$form_data['haslo'],$form_data['email']);
					redirect('/master/employees/1','location');					
				}
				
		}
		//wykluczenie zalogowanego uzytkownika
		$excluded_ids = array($data['master_id']);
		
		$data['employees']		= $this->baza->get_all_employees();
		$data['mainContent']	= $this->load->view('master/add_employee_form',$data,true);
		$this->load->view('/layout/master',$data);			
		
	}
	//------------------------------------------------------------------------------------------------------------------
	function delete_master($id)
	{
		$id = (int)$id;
		if($this->baza->delete_master($id))
			redirect('/master/masters/1', 'refresh');
		else
			redirect('/master/masters/0', 'refresh');		
	}	
	//------------------------------------------------------------------------------------------------------------------
	function delete_employee($id)
	{
		$id = (int)$id;
		if($this->baza->delete_employee($id))
			redirect('/master/employees/1', 'refresh');
		else
			redirect('/master/employees/0', 'refresh');		
	}
	//------------------------------------------------------------------------------------------------------------------
	function change_master_pass()
	{
		$data['user']  			= $this->user_data[0]['name'];
		$data['master_id']		= $this->session->userdata['master_id'];
		
		$form_data				= null;
		$errors					= null;
		
		if(!empty($_POST))
		{
			$form_data['haslo']   		= trim($_POST['haslo']);
			$form_data['nowe_haslo']    = trim($_POST['nowe_haslo']);
			$form_data['nowe_haslo2']   = trim($_POST['nowe_haslo2']);

			if($form_data['nowe_haslo2'] != $form_data['nowe_haslo'])
				$errors['nowe_haslo2'] = 'Potwierdzenie hasła jest niepoprawne.';
							
			if(empty($form_data['haslo']))
				$errors['haslo'] = 'Wartośc pola nie może być pusta';

			if(empty($form_data['nowe_haslo']))
				$errors['nowe_haslo'] = 'Wartośc pola nie może być pusta';
				
			if(empty($form_data['nowe_haslo2']))
				$errors['nowe_haslo2'] = 'Wartośc pola nie może być pusta';
								
			if(!$this->baza->is_valid_master_password($_POST['haslo'],$data['master_id']))
				$errors['haslo'] = 'Podane hasło jest niepoprawne.';				
				
				if($form_data != null && $errors != null)
				{
					$data['form_data']	    = $form_data;	
					$data['errors']	  		= $errors;
				}
				else
				{
					$this->baza->change_master_pass($form_data['nowe_haslo'],$data['master_id']);
					$haslo_md5 = md5($form_data['nowe_haslo']);
					$this->session->set_userdata('user_master_zalogowany',$haslo_md5);
					redirect('/master/masters/1','location');					
				}
		}		
		
		$data['mainContent']	= $this->load->view('master/change_master_pass_form',$data,true);
		$this->load->view('/layout/master',$data);		
	}
	//------------------------------------------------------------------------------------------------------------------	
	function is_valid_email($email){
		return eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $email);
	}

	//------------------------------------------------------------------------------------------------------------------
	function login()
	{
		$this->load->library('validation');
		$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
		
		$fields['login_form'] 	= 'login_form';
		$fields['pass'] 		= 'pass';
		$this->validation->set_fields($fields);
					
		$login_form 			= $this->validation->login_form;
		$pass_form			 	= $this->validation->pass;
		$rules['login_form'] 	= "callback_login_form_check|required";
		$rules['pass'] 			= "callback_pass_check[$login_form]|required";
		$this->validation->set_rules($rules);
		
		if($this->validation->run() == FALSE)
		{
			$this->load->view('/layout/home');		
		}
		else
		{
			$haslo_md5 		= md5($pass_form);
			$uzyt 			= $this->baza->master($login_form);
			$master_id 		= $uzyt[0]['id'];
			$this->session->set_userdata('user_master_zalogowany',$haslo_md5);
			$this->session->set_userdata('master_id',$master_id);
			
			redirect('/master/start','location');
		}		
	}	
	//------------------------------------------------------------------------------------------------------------------
	function logout()
	{
		$this->session->sess_destroy();
		redirect('/master','refresh');
	}	
	//------------------------------------------------------------------------------------------------------------------
	function login_form_check($str)
	{
		$user=$this->baza->master($str); 
		
		if ($user==null or $str==null)
		{
				$this->validation->set_message('login_form_check', 'Błędny login');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	//------------------------------------------------------------------------------------------------------------------
	function pass_check($pass,$login)
	{
		if($pass==null or $login==null)
		{
			$password = null; 	
		}
		else	
		{
			$haslo 		= md5($pass);
			$password 	= $this->baza->master_check_user_pass($haslo, $login); 	
		}
		
		if ($password == null)
		{
			$this->validation->set_message('pass_check', 'Błędne hasło');
			return FALSE;
		}
		else
		{	
			return TRUE;
		}
	}	
	//------------------------------------------------------------------------------------------------------------------
}