<?php

class Payments extends Controller {
	
	function Payments()
	{
		parent::Controller();
		$this->load->library('session');	
		$this->load->helper(array('form', 'url','html'));
		$this->load->model('baza_payments','',TRUE);
		$this->load->model('baza','',TRUE);
	}
			
	function index()
	{
		redirect('', 'location');		
	}
	
	function count_all_keywords_payments_per_week()
	{		
		$this->baza_payments->count_all_keywords_payments_per_week();
		echo 'zliczono wszystkie okresy oplat za keywordsy';	
	}
	
	//to trzeba dodac do curla do odpalenia w kazdy poniedzialek o godzinie 00:01
	function count_all_keywords_payments_last_week()
	{		
		$this->baza_payments->count_all_keywords_payments_last_week();
		echo '<br />zliczono ostatni tydzein oplat za keywordsy';	
	}
	
	//funkcja wystawiajaca fakture za miesiac poprzedzajacy aktualny miesiac
	//jezeli okres rozliczeniowy miesiaca poprzedzajacego aktualny miesiac nie dobiegl konca faktura nie zostanie wystawiona		
	function faktura()
	{ 		
		include_once('files/functions.php');
		header('Content-Type: text/html; charset=utf-8');
					
		//pobranie id wszystkich uzytkownikow
		$users = $this->baza->get_all_users();			
		$cur_month =  date('m');
		$cur_year =  date('Y');					
		$curr_date_of_facturing = $cur_year.'-'.$cur_month.'-'.date_from_nameday(1, 1, $cur_month,$cur_year); //data 1 dnia nowego okresu rozliczeniowego
		$user_id = null;		
		
		$poprzedni_miesiac = strftime("20%y-%m-%d",mktime(0,0,0,date("m")-1,'01',date("Y")));
		$year = substr($poprzedni_miesiac,0,4);
		$month = substr($poprzedni_miesiac,5,2);
		
		if($users!=null)	
		{										
			//sprawdzenie czy nie za wczesnie na wystawienie faktury za dany miesiac
			$facture_period = month_period_start_end($month,$year); //poczatek i koniec okresu rolziczeniowego danego miesaica w danym roku
			
			if(greaterDate($curr_date_of_facturing,$facture_period['end']))
			{											
				//petla generujaca wszystkie fakturki od $month i $year az do dzis
				foreach($users as $u)
				{
					$user_id = $u['id'];						
											 																														
					//pobranie danych faktury na konkretny miesiac i rok 
					$facture_data = $this->baza_payments->get_user_facture($user_id,$month,$year);
							
					if(empty($facture_data))
					{
						$do_zaplaty = array();
						$keywords_ids = array();	
					
						//pobierz wszystkie keyword id oraz dane dla zalogowanego usera
						$user_data	= $this->baza->get_user_data($user_id);
						$user_domins = $this->baza->get_domains($user_id);
						$domains_and_keywords = $this->baza_payments->get_domains_and_keywords($user_id);
						
						foreach($user_domins as $ud)
						{
							$do_zaplaty[$ud['domain']] = array();
						}									
						
						foreach($domains_and_keywords as $dk)
						{										
							//pobierz dane z oplat za tydzein dla danego keyworda roku i miesiaca
							$weeks_payments_data = $this->baza_payments->get_data_to_fakcture_payments($dk['id'],$month,$year);										 
														
							if(!empty($weeks_payments_data))
							{
								if($dk['naliczona_oplata_za_dojscie']==0)
								{								
									$do_zaplaty[trim($dk['domain'])][] = array('dojscie',$dk['domain'],$dk['keyword'],$dk['price']);
									//oznaczenie w bazie ze juz naliczono oplate za dojscie dla tego keyworda
									$this->baza_payments->update_keyword_dojscie($dk['id']);																
								}

								if($month==1 or $month==12)
								{
									$do_zaplaty[trim($dk['domain'])][] = array('tydzien',$dk['domain'],$dk['keyword'],$weeks_payments_data[0]['oplata_za_miesaic'],$weeks_payments_data[0]['month'],$weeks_payments_data[0]['year'],$weeks_payments_data[0]['ilosc_tyg_platnych'],$weeks_payments_data[0]['cena_za_tydz'],$weeks_payments_data[0]['ostatni_week']);
									$keywords_ids[]= $dk['id']; 
								}
								else
								{	
									$do_zaplaty[trim($dk['domain'])][] = array('tydzien',$dk['domain'],$dk['keyword'],$weeks_payments_data[0]['oplata_za_miesaic']);
								}
							}														
						}
												
						//naliczanie zlotowki na koniec roku
						$styczen = false;
						$grudzien = false;
						
						if(!empty($keywords_ids))
						{	
							if($month==1)
							{									
								//tablica z inforamcjami o ostatnim tygodniu poprzedniego roku
								$dane = last_week_of_year($year-1);							
								$month_zak = substr($dane[0]['end'],5,2);
											
								//jezeli koniec ostatniego tyg  roku-1 byl 01 to sprawdz czy za tamten tydzein byly jakies oplaty, jezeli tak to dolicz zlotowke																
								
								if($month_zak=='01')
								{																				
									$d = $this->baza_payments->zloty_check($keywords_ids,$dane[0]['week_number'],($year-1));
									
									//czy sa oplaty za ostatni tydzien roku poprzedniego
									if(!empty($d))	$styczen = true;
									
								}										

								if($styczen)
								{																						
									foreach($do_zaplaty as $key => $value)
									{
										if(!empty($value))
											$do_zaplaty[$key][] =  '1zl';	
									}									
								}										
							}
							
							if($month==12)
							{			
								//tablica z inforamcjami o ostatnim tygodniu poprzedniego roku
								$dane = last_week_of_year($year);							
								$month_zak = substr($dane[0]['end'],5,2);
												
								//jezeli koniec ostatniego tyg  roku byl 12 to sprawdz czy za ten tydzein byly jakies oplaty, jezeli tak to dolicz zlotowke zamiast tych oplat								
								
								if($month_zak=='01')
								{										
									$d = $this->baza_payments->zloty_check($keywords_ids,$dane[0]['week_number'],$year);
									
									//czy sa oplaty za ostatni tydzien roku poprzedniego
									if(!empty($d))	$grudzien = true;
									
								}											
								
								if($grudzien)
								{
									foreach($do_zaplaty as $key => $value)
									{
										if(!empty($value))
											$do_zaplaty[$key][] =  '1zl';	
									}									
								}
							}
						}	
								
						//sprawdz czy sa jakies platnosci za dany miesiac
						$check_tmp = null;
						foreach($do_zaplaty as $k => $v)
						{											
							if(!empty($v))
								$check_tmp = $v;
						}
																			
						if(!empty($check_tmp))	
						{								
							$this->baza_payments->add_facture($month,$year,$facture_period,$do_zaplaty,$user_data);							
							echo 'Faktura dla <b>'.$user_data[0]['company_name'].'</b> za okres '.$facture_period['start'].'-'.$facture_period['end'].'  została wystawiona <br />';
						}																				 																																			
					}
					elseif(count($facture_data)>1)
					{
						echo 'critical error, poinformuj jak najszybciej swojego networds managera o tym wyjatku';
						exit;
					}
					else
					{
						echo 'już sa wystawione faktury za ten okres rozliczeniowy';
						exit;
					}																									
				}
			}
			else
			{
				echo 'Za wczesnie na wystawienie faktury za podany okres!!';
				exit;														
			}								
		}
		else
		{				
			echo 'Brak autoryzacji';	
		}						
	}	
	
	//funkcja wystawia wszystkie nie istniejace faktury od 2008 roku az do dzis
	function faktura_all($start_year=2005)
	{ 		
		if(!empty($start_year))
		{			
			include_once('files/functions.php');
						
			//pobranie id wszystkich uzytkownikow
			$users = $this->baza->get_all_users();			
			$cur_month =  date('m');
			$cur_year =  date('Y');					
			$curr_date_of_facturing = $cur_year.'-'.$cur_month.'-'.date_from_nameday(1, 1, $cur_month,$cur_year); //data 1 dnia nowego okresu rozliczeniowego
			$user_id = null;
			
			if($users!=null)	
			{
				//petla wystawiajaca fakturki za wszystkie okresy do dzis
				for($year=$start_year;$year<=$cur_year;$year++)
				{
					for($month=1;$month<=12;$month++)
					{							
						//sprawdzenie czy nie za wczesnie na wystawienie faktury za dany miesiac
						$facture_period = month_period_start_end($month,$year); //poczatek i koniec okresu rolziczeniowego danego miesaica w danym roku
						
						if(greaterDate($curr_date_of_facturing,$facture_period['end']))
						{							
							//petla generujaca wszystkie fakturki od $month i $year az do dzis
							foreach($users as $u)
							{
								$user_id = $u['id'];						
														 																														
								//pobranie danych faktury na konkretny miesiac i rok 
								$facture_data = $this->baza_payments->get_user_facture($user_id,$month,$year);
										
								if(empty($facture_data))
								{
									$do_zaplaty = array();
									$keywords_ids = array();	
								
									//pobierz wszystkie keyword id oraz dane dla zalogowanego usera
									$user_data	= $this->baza->get_user_data($user_id);
									$user_domins = $this->baza->get_domains($user_id);
									$domains_and_keywords = $this->baza_payments->get_domains_and_keywords($user_id);
									
									foreach($user_domins as $ud)
									{
										$do_zaplaty[$ud['domain']] = array();
									}									
									
									foreach($domains_and_keywords as $dk)
									{										
										//pobierz dane z oplat za tydzein dla danego keyworda roku i miesiaca
										$weeks_payments_data = $this->baza_payments->get_data_to_fakcture_payments($dk['id'],$month,$year);										 
																	
										if(!empty($weeks_payments_data))
										{
											if($dk['naliczona_oplata_za_dojscie']==0)
											{								
												$do_zaplaty[trim($dk['domain'])][] = array('dojscie',$dk['domain'],$dk['keyword'],$dk['price']);
												//oznaczenie w bazie ze juz naliczono oplate za dojscie dla tego keyworda
												$this->baza_payments->update_keyword_dojscie($dk['id']);																
											}

											if($month==1 or $month==12)
											{
												$do_zaplaty[trim($dk['domain'])][] = array('tydzien',$dk['domain'],$dk['keyword'],$weeks_payments_data[0]['oplata_za_miesaic'],$weeks_payments_data[0]['month'],$weeks_payments_data[0]['year'],$weeks_payments_data[0]['ilosc_tyg_platnych'],$weeks_payments_data[0]['cena_za_tydz'],$weeks_payments_data[0]['ostatni_week']);
												$keywords_ids[]= $dk['id']; 
											}
											else
											{	
												$do_zaplaty[trim($dk['domain'])][] = array('tydzien',$dk['domain'],$dk['keyword'],$weeks_payments_data[0]['oplata_za_miesaic']);
											}
										}														
									}
																		
									//naliczanie zlotowki na koniec roku
									$styczen = false;
									$grudzien = false;
									
									if(!empty($keywords_ids))
									{	
										if($month==1)
										{												
											//tablica z inforamcjami o ostatnim tygodniu poprzedniego roku
											$dane = last_week_of_year($year-1);							
											$month_zak = substr($dane[0]['end'],5,2);
													
											//jezeli koniec ostatniego tyg  roku-1 byl 01 to sprawdz czy za tamten tydzein byly jakies oplaty, jezeli tak to dolicz zlotowke																			
											
											if($month_zak=='01')
											{																							
												$d = $this->baza_payments->zloty_check($keywords_ids,$dane[0]['week_number'],($year-1));
												
												//czy sa oplaty za ostatni tydzien roku poprzedniego
												if(!empty($d))	$styczen = true;
												
											}														

											if($styczen)
											{																												
												foreach($do_zaplaty as $key => $value)
												{
													if(!empty($value))
														$do_zaplaty[$key][] =  '1zl';	
												}												
											}													
										}
										
										if($month==12)
										{			
											//tablica z inforamcjami o ostatnim tygodniu poprzedniego roku
											$dane = last_week_of_year($year);							
											$month_zak = substr($dane[0]['end'],5,2);
															
											//jezeli koniec ostatniego tyg  roku byl 12 to sprawdz czy za ten tydzein byly jakies oplaty, jezeli tak to dolicz zlotowke zamiast tych oplat											
											
											if($month_zak=='01')
											{													
												$d = $this->baza_payments->zloty_check($keywords_ids,$dane[0]['week_number'],$year);
												
												//czy sa oplaty za ostatni tydzien roku poprzedniego
												if(!empty($d))	$grudzien = true;
												
											}			
											
											if($grudzien)
											{
												foreach($do_zaplaty as $key => $value)
												{
													if(!empty($value))
														$do_zaplaty[$key][] =  '1zl';	
												}												
											}
										}
									}	
											
									//sprawdz czy sa jakies platnosci za dany miesiac
									$check_tmp = null;
									foreach($do_zaplaty as $k => $v)
									{											
										if(!empty($v))
											$check_tmp = $v;
									}
																												
									if(!empty($check_tmp))	
									{											
										$this->baza_payments->add_facture($month,$year,$facture_period,$do_zaplaty,$user_data);
									}
																							 																																			
								}
								elseif(count($facture_data)>1)
								{
									echo 'critical error, poinformuj jak najszybciej swojego networds managera o tym wyjatku';
									//exit;
								}															
							}
						}
						else
						{
							echo 'Wszystkie faktury do dzis zostaly wystawione';
							exit;														
						}							
					}
				}
			}
			else
			{				
				echo 'Brak autoryzacji';	
			}						
		}
		else
		{
			echo 'error';
		}	
	}	
	
	function faktura_pdf($month=null,$year=null)
	{ 
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			$dane = $this->baza_payments->get_facture($this->session->userdata['di'],$month,$year);			
			
			if($user_data!=null and $dane!=null)	
			{									
				require_once('files/faktura_template.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);
				   
				//informacje o numerze faktury
				$faktura_info = "Faktura VAT\nnr: FV ".$faktura['nr']."/SEO/".$faktura['month']."/".$faktura['year']."\nOrginał";
				$pdf->MultiCell(90,7,$faktura_info,1,'L');
				
				//nazwy informacji o datach i sposobie przelewu
				$pdf->SetFont('Trebuchet','',10);
				$pdf->SetXY(115, 20);
				$payment_info = "Miejsce wystawienia:\nData wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
				$pdf->MultiCell(37,5,$payment_info,0,'L');
		 
				//informacje o datach i sposobie przelewu
				$pdf->SetFont('Trebuchet','',10);
				$pdf->SetXY(152, 20);
				$payment_info_data = "".$faktura['miejsce_wystawienia']."\n".$faktura['data_wystawienia']."\n".$faktura['data_sprzedazy']."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
				$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
				$pdf->Ln(5);
				   
				//informacje o sprzedawcy    
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Sprzedawca:',0,1);
				$pdf->SetFont('Trebuchet','',10);
				$seller_info = $faktura['sprzedawca'];
				$pdf->MultiCell(90,5,$seller_info,0,'L');
				
		        //informacje o nabywcy  
		        $pdf->SetXY(115, 50); 
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Nabywca:',0,1);
				$pdf->SetXY(115, 55);
				$pdf->SetFont('Trebuchet','',10);
		        $buyer_info = $faktura['nabywca'];
				$pdf->MultiCell(85,5,$buyer_info,0,'L');
				
				$pdf->Ln(20);
				
				//tabela z naliczonymi platnosciami
				$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
				$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
				$dane_platnosci_faktury[]=explode(';',chop($line));

				$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
								
				//tabela z 9 kolumnami 
				$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
				//ustawia pozycje tekstu w kazdej kolumnie
				$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
				//header tabeli
				$pdf->Row($table_header);								
				
				foreach($naliczone_uslugi as $u)
				{
					$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
				}
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(1);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(30); 
				
				//miejsce na podpisy
				$pdf->SetX(125);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
				$pdf->Ln(7); 
				$pdf->SetFont('Trebuchet','',10);
				$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
				$pdf->SetX(127);
				$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
		
				//nowa strona
				$pdf->AddPage();
				//uwagi				
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Uwagi:',0,1);
				$pdf->Ln(10);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
				 
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}	
}
?>